package com.bxm.warcar.container.autoconfigure.task;

import com.bxm.warcar.container.task.RemoteExecutor;
import com.bxm.warcar.container.task.Shutdown;
import com.bxm.warcar.container.task.TaskMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@ConditionalOnProperty(prefix = "warcar.container", name = {"enabled"}, havingValue = "true")
public class TaskAutoConfiguration implements ApplicationListener<ContextRefreshedEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAutoConfiguration.class);

    private RemoteExecutor remoteExecutor;

    @Bean
    public TaskMetrics taskMetrics() {
        return new TaskMetrics();
    }

    @Bean
    public RemoteExecutor remoteExecutor() {
        this.remoteExecutor = new RemoteExecutor(taskMetrics());
        return this.remoteExecutor;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (context.getParent() == null) {
            Map<String, Shutdown> beansOfType = context.getBeansOfType(Shutdown.class);
            Set<Map.Entry<String, Shutdown>> entries = beansOfType.entrySet();
            for (Map.Entry<String, Shutdown> entry : entries) {
                Shutdown bean = entry.getValue();
                this.remoteExecutor.add(bean);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Registering shutdown bean {}", bean);
                }
            }
        }
    }
}
