/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.alions;

import com.aliyun.openservices.ons.api.Producer;
import com.bxm.warcar.mq.alions.AlionsProducer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AlionsConfiguration.class, AlionsPropsConfiguration.class})
@ConditionalOnClass(value={Producer.class})
public class AlionsAutoConfiguration {
    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private AlionsPropsConfiguration propsConfiguration;

    @Bean(initMethod="init", destroyMethod="destroy")
    public AlionsProducer alionsProducer() {
        Properties config = this.propsConfiguration.getConfig();
        if (null != config) {
            return new AlionsProducer(config);
        }
        return new AlionsProducer(this.configuration.getProducerId(), this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }
}

