/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.base.Preconditions;

import java.util.List;
import java.util.Map;

/**
 * <h3>支持序列化的结构是数组，统一存储。</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public abstract class AbstractArrayToObjectPushable<T> extends AbstractPushable<T> {

    public AbstractArrayToObjectPushable() {
        super();
    }

    public AbstractArrayToObjectPushable(Converter converter) {
        super(converter);
    }

    protected abstract List<T> serialize(byte[] data);

    protected abstract KeyGenerator getKeyGenerator(Map<String, Object> parameters);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Updater updater = getUpdater();
        Preconditions.checkNotNull(updater);

        List<T> objects = serialize(data);
        KeyGenerator keyGenerator = getKeyGenerator(parameters);
        if (this instanceof HashUpdating) {
            for (T object : objects) {
                String field = ((HashUpdating) this).getField(parameters, object);
                Object o = this.converter.convert(object);
                updater.hupdate(keyGenerator, field, o);
            }
        }
        else {
            Object o = this.converter.convert(objects);
            updater.update(keyGenerator, o);
        }
    }
}
