/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.base.Preconditions;

import java.util.Map;

/**
 * @see JSONObjectPushable
 * @author allen
 * @date 2017-12-05
 */
public abstract class AbstractObjectPushable<T> extends AbstractPushable<T> {

    public AbstractObjectPushable() {
        super();
    }

    public AbstractObjectPushable(Converter converter) {
        super(converter);
    }

    /**
     * 将请求中的数据序列化
     *
     * @param data
     * @return
     */
    protected abstract T serialize(byte[] data);

    /**
     * 返回缓存的KEY
     *
     * @param parameters 参数列表
     * @return
     */
    protected abstract KeyGenerator getKeyGenerator(Map<String, Object> parameters);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {

        Updater updater = getUpdater();
        Preconditions.checkNotNull(updater);

        T object = serialize(data);

        KeyGenerator keyGenerator = getKeyGenerator(parameters);
        Object o = this.converter.convert(object);
        if (this instanceof HashUpdating) {
            String field = ((HashUpdating<T>) this).getField(parameters, object);
            updater.hupdate(keyGenerator, field, o);
        }
        else {
            updater.update(keyGenerator, o);
        }

        afterUpdated(parameters, object);
    }
}
