/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.Updater;

import java.util.Map;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public abstract class AbstractPushable<T> implements Pushable {

    protected final Converter converter;

    public AbstractPushable() {
        this(Converter.DEFAULT);
    }

    public AbstractPushable(Converter converter) {
        this.converter = converter;
    }

    /**
     * 返回更新器
     * @return
     */
    protected abstract Updater getUpdater();

    protected void afterUpdated(Map<String, Object> parameters, T object) {
        // Empty implementation
    }
}
