package com.bxm.warcar.cache.serialization;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2017-12-04
 */
public class JSONSerialization implements Serialization<String> {

    @Override
    public String serialize(Object data) {
        return JSON.toJSONString(data);
    }

    @Override
    public <T> T deserialize(String modalValue, Class<T> cls) {
        return JSON.parseObject(modalValue, cls);
    }

    public <T> List<T> deserializeList(String modalValue, Class<T> cls) {
        return JSON.parseArray(modalValue, cls);
    }

    @Override
    public <T> Map<String, T> deserializeMap(String modalValue, Class<T> cls) {
        return JSONObject.parseObject(modalValue, Map.class);
    }
}
