/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.DefaultValTrackable;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.TypeHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;

public class JedisCounter
implements Counter {
    private final JedisPool jedisPool;

    public JedisCounter(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public Long incrementAndGet(KeyGenerator keyGenerator) {
        return this.incrementAndGet(keyGenerator, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long incr = jedis.incr(key);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = incr;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Long incrementByAndGet(KeyGenerator keyGenerator, long inc) {
        return this.incrementByAndGet(keyGenerator, inc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrementByAndGet(KeyGenerator keyGenerator, long inc, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long incr = jedis.incrBy(key, inc);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = incr;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Long decrementAndGet(KeyGenerator keyGenerator) {
        return this.decrementAndGet(keyGenerator, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long decr = jedis.decr(key);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = decr;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Long decrementByAndGet(KeyGenerator keyGenerator, long dec) {
        return this.decrementByAndGet(keyGenerator, dec, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrementByAndGet(KeyGenerator keyGenerator, long dec, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long decr = jedis.decrBy(key, dec);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = decr;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(KeyGenerator keyGenerator, long value) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key, String.valueOf(value));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long get(KeyGenerator keyGenerator) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = TypeHelper.castToLong((Object)jedis.get(key));
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Long hincrementAndGet(KeyGenerator keyGenerator, String field) {
        return this.hincrementAndGet(keyGenerator, field, 0);
    }

    @Override
    public Long hincrementAndGet(KeyGenerator keyGenerator, String field, int expireTimeInSecond) {
        return this.hincrementByAndGet(keyGenerator, field, 1L, expireTimeInSecond);
    }

    @Override
    public Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc) {
        return this.hincrementByAndGet(keyGenerator, field, inc, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long decr = jedis.hincrBy(key, field, inc);
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = decr;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hget(KeyGenerator keyGenerator, String field) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String v = jedis.hget(key, field);
            Long l = NumberUtils.toLong((String)v, (long)0L);
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrementAndGet(KeyGenerator keyGenerator, DefaultValTrackable defaultValTracker, long min, int expireTimeInSecond) {
        String key = this.getKey(keyGenerator);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.watch(new String[]{key});
            String oldValue = jedis.get(key);
            if (null == oldValue) {
                long start = defaultValTracker.getDefaultVal();
                Transaction t1 = jedis.multi();
                String startValue = String.valueOf(start);
                jedis.set(key, startValue);
                t1.set(key, startValue);
                List r1 = t1.exec();
                if (!this.isFinished(r1)) {
                    throw new IllegalStateException("Cannot initialized key-value for :" + key);
                }
                oldValue = startValue;
                jedis.watch(new String[]{key});
            }
            long old = NumberUtils.toLong((String)oldValue, (long)min);
            if (old-- < min) {
                throw new IndexOutOfBoundsException();
            }
            Transaction transaction = jedis.multi();
            transaction.set(key, String.valueOf(old));
            List result = transaction.exec();
            boolean failed = this.isFinished(result);
            if (failed) {
                throw new IllegalStateException();
            }
            this.setExpire(jedis, key, expireTimeInSecond);
            Long l = old;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.unwatch();
                jedis.close();
            }
        }
    }

    private void setExpire(Jedis jedis, String key, int expireTimeInSecond) {
        if (expireTimeInSecond > 0) {
            jedis.expire(key, expireTimeInSecond);
        }
    }

    private boolean isFinished(List<Object> result) {
        return null == result || null == result.get(0);
    }

    private String getKey(KeyGenerator keyGenerator) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        return key;
    }
}

