/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;

import java.util.List;
import java.util.Map;

/**
 * <h3>支持多个对象，并多个对象单独存储的实现。</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public abstract class AbstractArrayPushable<T> extends AbstractPushable<T> {

    public AbstractArrayPushable() {
        super();
    }

    public AbstractArrayPushable(Converter converter) {
        super(converter);
    }

    protected abstract List<T> serialize(byte[] data);

    protected abstract KeyGenerator getKeyGenerator(Map<String, Object> parameters, T object);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        List<T> objects = ArrayUtils.isNotEmpty(data) ? serialize(data) : null;

        // TODO 当数据集为空时无法进行子元素的删除操作。
        if (CollectionUtils.isNotEmpty(objects)) {
            for (T object : objects) {
                KeyGenerator keyGenerator = getKeyGenerator(parameters, object);
                doUpdate(object, keyGenerator, parameters, data);
            }
        }
    }
}
