/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.base.Preconditions;

import java.util.Map;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public abstract class AbstractPushable<T> implements Pushable {

    protected final Converter converter;

    public AbstractPushable() {
        this(Converter.DEFAULT);
    }

    public AbstractPushable(Converter converter) {
        this.converter = converter;
    }

    /**
     * 返回更新器
     * @return
     */
    protected abstract Updater getUpdater();

    protected void beforeUpdate(Map<String, Object> parameters, byte[] data, T object) {
        // Empty implementation
    }

    protected void afterUpdated(Map<String, Object> parameters, T object) {
        // Empty implementation
    }

    protected void doUpdate(T object, KeyGenerator keyGenerator, Map<String, Object> parameters, byte[] data) {
        Updater updater = getUpdater();
        Preconditions.checkNotNull(updater);

        beforeUpdate(parameters, data, object);
        Object o = this.converter.convert(object);
        if (this instanceof HashUpdating) {
            String field = ((HashUpdating<T>) this).getField(parameters, object);
            updater.hremove(keyGenerator, field);
            if (null != o) {
                updater.hupdate(keyGenerator, field, o);
            }
        }
        else {
            updater.remove(keyGenerator);
            if (null != o) {
                updater.update(keyGenerator, o);
            }
        }
        afterUpdated(parameters, object);
    }
}
