/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;

public class JedisFetcher
implements Fetcher {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public JedisFetcher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    @Override
    public Object getClientOriginal() {
        return this.jedisPool;
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls) {
        return this.fetch(keyGenerator, null, cls);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.fetch(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.fetch(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.fetchWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls) {
        return this.fetchList(keyGenerator, null, cls);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        return this.fetchList(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.fetchList(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.fetchListWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return this.hfetch(keyGenerator, field, null, cls);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return this.hfetch(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.hfetch(keyGenerator, field, dataExtractor, cls, 0);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchWithSelector(keyGenerator, field, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return this.hfetchList(keyGenerator, field, null, cls);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchList(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        return this.hfetchList(keyGenerator, field, dataExtractor, cls, 0);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchListWithSelector(keyGenerator, field, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls) {
        return this.hfetchall(keyGenerator, null, cls);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchall(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls) {
        return this.hfetchall(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.fetchWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int selector) {
        return this.fetchWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.fetchWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.fetchListWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int selector) {
        return this.fetchListWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.fetchListWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, null, cls, selector);
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, cls, 0, selector);
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.hfetchallWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchallWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchallWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            Object hscan;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            HashMap rst = Maps.newHashMap();
            String startCursor = "0";
            String cursor = "0";
            do {
                hscan = jedis.hscan(key, cursor, new ScanParams().count(Integer.valueOf(10000)));
                cursor = hscan.getStringCursor();
                List result = hscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Map.Entry entry : result) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    rst.put(k, this.serialization.deserialize(v, cls));
                }
            } while (!cursor.equals("0"));
            if (MapUtils.isNotEmpty((Map)rst)) {
                hscan = rst;
                return hscan;
            }
            Map<String, T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                Set<Map.Entry<String, T>> entries = fromStore.entrySet();
                for (Map.Entry entry : entries) {
                    jedis.hset(key, (String)entry.getKey(), this.serialization.serialize(entry.getValue()));
                }
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            Map<String, T> map = fromStore;
            return map;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchallWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }
}

