/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.eventbus.EventBus;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class AbstractEventPark
implements ApplicationListener<ContextRefreshedEvent>,
EventPark {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventPark.class);
    private static final int CORE_SIZE = Runtime.getRuntime().availableProcessors();

    protected abstract EventBus getEventBus();

    @Override
    public void register(EventListener listener) {
        this.getEventBus().register((Object)listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering listeners to AsyncEventPark: {}", (Object)listener);
        }
    }

    @Override
    public void unregister(EventListener listener) {
        this.getEventBus().unregister((Object)listener);
    }

    @Override
    public void post(EventObject eventObject) {
        this.getEventBus().post((Object)eventObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EventBus post event: {}", (Object)eventObject);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext.getParent() == null) {
            Map beansOfType = applicationContext.getBeansOfType(EventListener.class);
            Set entries = beansOfType.entrySet();
            for (Map.Entry entry : entries) {
                this.register((EventListener)entry.getValue());
            }
        }
    }
}

