/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.message;

import com.bxm.warcar.integration.message.MessageProducer;
import com.bxm.warcar.integration.message.annotation.Messaging;
import com.bxm.warcar.mq.Producer;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProducer
implements MessageProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProducer.class);
    protected final Producer producer;
    protected final Object properties;

    public AbstractMessageProducer(Producer producer, Object properties) {
        this.producer = producer;
        this.properties = properties;
    }

    protected abstract void sendMessage(String var1, Object var2, Object var3, Messaging var4);

    @Override
    public void send(Object[] args, Object returning, Messaging messaging) {
        if (ArrayUtils.isEmpty((Object[])args) || args.length > 1) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Not supported none or multi arguments of method!");
            }
            return;
        }
        if (null == returning) {
            return;
        }
        if (null == messaging) {
            return;
        }
        String topic = this.getTopic(messaging);
        if (StringUtils.isNotBlank((String)topic)) {
            this.sendMessage(topic, returning, args[0], messaging);
        }
    }

    @Override
    public Producer getProducer() {
        return this.producer;
    }

    @Override
    public Object getProperties() {
        return this.properties;
    }

    private String getTopic(Messaging annotation) {
        try {
            String topic = annotation.value();
            if (StringUtils.isBlank((String)topic)) {
                topic = BeanUtils.getProperty((Object)this.properties, (String)annotation.topicFieldNameOfConfiguration());
            }
            return topic;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getTopic: ", (Throwable)e);
            }
            return null;
        }
    }
}

