/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.alions;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.bxm.warcar.mq.DelayTimeLevel;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.utils.LifeCycle;
import java.util.Properties;

public class AlionsProducer
extends LifeCycle
implements Producer {
    private final Properties properties = new Properties();
    private com.aliyun.openservices.ons.api.Producer producer;

    public AlionsProducer(String producerId, String accessKey, String secretKey) {
        this.properties.put("ProducerId", producerId);
        this.properties.put("AccessKey", accessKey);
        this.properties.put("SecretKey", secretKey);
        this.producer = ONSFactory.createProducer((Properties)this.properties);
    }

    @Override
    public SendResult send(Message message) {
        com.aliyun.openservices.ons.api.SendResult sendResult;
        com.aliyun.openservices.ons.api.Message msg = new com.aliyun.openservices.ons.api.Message();
        msg.setTopic(message.getTopic());
        msg.setBody(message.getBody());
        msg.setTag(message.getTags());
        int level = message.getDelayTimeLevel();
        if (level > 0) {
            msg.setStartDeliverTime(DelayTimeLevel.ofSystemTimeInMillis(level));
        }
        if (null == (sendResult = this.producer.send(msg))) {
            throw new SendException();
        }
        return new SendResult(sendResult.getMessageId());
    }

    protected void doInit() {
        if (null != this.producer && this.producer.isClosed()) {
            this.producer.start();
        }
    }

    protected void doDestroy() {
        if (null != this.producer && this.producer.isStarted()) {
            this.producer.shutdown();
        }
    }
}

