package com.bxm.warcar.mq.kafka;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.utils.LifeCycle;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.util.Properties;
import java.util.concurrent.Future;

/**
 * @author allen
 * @since 1.0.0
 */
public class KafkaProducer extends LifeCycle implements Producer {

    private org.apache.kafka.clients.producer.Producer<String, byte[]> producer;

    /**
     * A producer is instantiated by providing a set of key-value pairs as configuration. Valid configuration strings
     * are documented <a href="http://kafka.apache.org/documentation.html#producerconfigs">here</a>.
     * @param properties   The producer configs
     */
    public KafkaProducer(Properties properties) {
        this.producer = new org.apache.kafka.clients.producer.KafkaProducer<String, byte[]>(properties);
    }

    @Override
    protected void doInit() {

    }

    @Override
    protected void doDestroy() {
        this.close();
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String key = message.getKey();
        byte[] data = message.getBody();
        try {
            Future<RecordMetadata> future = producer.send(new ProducerRecord<String, byte[]>(topic, key, data));
            RecordMetadata metadata = future.get();
            String msgId = KafkaMsgIdUtils.generate(topic, metadata.partition(), metadata.offset());
            return new SendResult(msgId);
        } catch (Exception e) {
            throw new SendException(e);
        }
    }

    @Override
    public void start() {

    }

    @Override
    public void close() {
        if (null != producer) {
            producer.close();
        }
    }

    @Override
    public boolean isStarted() {
        return true;
    }
}
