/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.math.NumberUtils;

import java.util.Map;

/**
 * <h3>字符串模型</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
public abstract class AbstractStringPushable extends AbstractPushable<String> {

    public AbstractStringPushable() {
        super();
    }

    public AbstractStringPushable(Converter converter) {
        super(converter);
    }

    /**
     * 返回缓存的KEY
     *
     * @param parameters 参数列表
     * @return
     */
    protected abstract KeyGenerator getKeyGenerator(Map<String, Object> parameters);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Updater updater = getUpdater();
        Preconditions.checkNotNull(updater);

        KeyGenerator keyGenerator = getKeyGenerator(parameters);
        String object = StringHelper.convert(data);

        Object o = this.converter.convert(object);
        if (this instanceof HashUpdating) {
            String field = ((HashUpdating<String>) this).getField(parameters, object);
            updater.hupdate(keyGenerator, field, o);
        }
        else {
            updater.update(keyGenerator, o);
        }
    }
}
