/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.StringHelper;

import java.util.List;

/**
 * JSONArray 数组模型 推送抽象实现。
 * @param <T> 需要从请求数据<code>byte[]</code> 序列化后的对象
 *
 * @author allen
 * @since V1.0.0 2017/12/12
 */
public abstract class JSONArrayToObjectPushable<T> extends AbstractArrayToObjectPushable<T> {

    public JSONArrayToObjectPushable() {
        super();
    }

    public JSONArrayToObjectPushable(Converter converter) {
        super(converter);
    }

    /**
     * 返回序列化对象类型
     * @return
     */
    protected abstract Class<T> getClsType();

    @Override
    protected List<T> serialize(byte[] data) {
        return JSON.parseArray(StringHelper.convert(data), getClsType());
    }
}
