/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.utils;

import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * <h3>时间帮助类</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
public final class DateHelper {

    private DateHelper() {}

    public static final long SECONDS_OF_DAY = 24 * 60 * 60;

    /**
     * 返回今天剩余秒数
     * @return
     */
    public static long getRemainSecondsOfToday() {
        return getRemainSecondsOfDay(1);
    }

    public static long getRemainSecondsOfDay(int day) {
        return (SECONDS_OF_DAY * day) - DateUtils.getFragmentInSeconds(Calendar.getInstance(), Calendar.DATE);
    }

    /**
     * yyyyMMdd
     * @return
     */
    public static String getDate() {
        return format("yyyyMMdd");
    }

    public static String format(String pattern) {
        return DateFormatUtils.format(Calendar.getInstance(), pattern);
    }
}
