package com.bxm.warcar.cache;

import java.util.Map;

/**
 * 更新器
 */
public interface Updater {

    void update(KeyGenerator keyGenerator, Object value);

    void update(KeyGenerator keyGenerator, Object value, int expireTimeInSecond);

    void mupdate(KeyGenerator keyGenerator, Map<String, Object> values);

    void mupdate(KeyGenerator keyGenerator, Map<String, Object> values, int expireTimeInSecond);

    void remove(KeyGenerator keyGenerator);

    void hupdate(KeyGenerator keyGenerator, String field, Object value);

    void hupdate(KeyGenerator keyGenerator, String field, Object value, int expireTimeInSecond);

    void hremove(KeyGenerator keyGenerator, String...field);

    /**
     * 返回这个获取器具体的实现原生客户端
     * @return
     */
    Object getClientOriginal();
}
