package com.bxm.warcar.cache.impls.jvm;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JvmFetcher implements Fetcher {

    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap<>();

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return fetch(keyGenerator, dataExtractor, cls, 0);
    }

    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }

        String key = keyGenerator.generateKey();

        if (null == key || "".equals(key.trim())) {
            throw new NullPointerException("key");
        }

        Object fromCache = cache.get(key);

        if (null != fromCache) {
            return (T) fromCache;
        }

        Object fromStore = null;
        if (null != dataExtractor) {
            fromStore = dataExtractor.extract();
        }

        if (null != fromStore) {

            cache.put(key, fromStore);

            return (T) fromStore;
        }
        return null;
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls) {
        return fetch(keyGenerator, null, cls);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return fetch(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls) {
        return fetchList(keyGenerator, null, cls);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return fetchList(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return hfetch(keyGenerator, field, null, cls);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return hfetch(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return hfetchList(keyGenerator, field, null, cls);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return hfetchList(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls) {
        return hfetchall(keyGenerator, null, cls);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return hfetchall(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public Object getClientOriginal() {
        return cache;
    }
}
