/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.alions;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.MessageListener;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class AlionsConsumer
extends LifeCycle
implements Consumer {
    private final Properties properties = new Properties();
    private com.aliyun.openservices.ons.api.Consumer consumer;
    private final Listener messageListener;
    private String subExpression;

    public AlionsConsumer(String consumerId, String accessKey, String secretKey, Listener messageListener) {
        Preconditions.checkNotNull((Object)messageListener);
        this.properties.put("ConsumerId", consumerId);
        this.properties.put("AccessKey", accessKey);
        this.properties.put("SecretKey", secretKey);
        this.messageListener = messageListener;
    }

    public AlionsConsumer(Properties properties, Listener messageListener) {
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull((Object)messageListener);
        this.properties.putAll((Map<?, ?>)properties);
        this.messageListener = messageListener;
    }

    public AlionsConsumer(String consumerId, Properties properties, Listener messageListener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)consumerId));
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull((Object)messageListener);
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put("ConsumerId", consumerId);
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        this.consumer = ONSFactory.createConsumer((Properties)this.properties);
        if (null != this.consumer) {
            String topic = this.messageListener.getTopic();
            if (StringUtils.isBlank((String)topic)) {
                throw new RuntimeException("topic must has not blank!");
            }
            if (StringUtils.isBlank((String)this.subExpression)) {
                this.subExpression = "*";
            }
            this.consumer.subscribe(topic, this.subExpression, new com.aliyun.openservices.ons.api.MessageListener(){

                public Action consume(com.aliyun.openservices.ons.api.Message message, ConsumeContext context) {
                    Message msg = new Message();
                    msg.setTopic(message.getTopic());
                    msg.setBody(message.getBody());
                    msg.setTags(message.getTag());
                    msg.setKey(message.getKey());
                    msg.setMsgId(message.getMsgID());
                    msg.setReconsumeTimes(message.getReconsumeTimes());
                    Enum status = null;
                    if (AlionsConsumer.this.messageListener instanceof MessageListener) {
                        status = ((MessageListener)AlionsConsumer.this.messageListener).consume(Lists.newArrayList((Object[])new Message[]{msg}), context);
                    } else if (AlionsConsumer.this.messageListener instanceof SingleMessageListener) {
                        status = ((SingleMessageListener)AlionsConsumer.this.messageListener).consume(msg, context);
                    }
                    if (null == status) {
                        return Action.ReconsumeLater;
                    }
                    switch (2.$SwitchMap$com$bxm$warcar$mq$ConsumeStatus[status.ordinal()]) {
                        case 1: {
                            return Action.CommitMessage;
                        }
                    }
                    return Action.ReconsumeLater;
                }
            });
            if (this.consumer.isClosed()) {
                this.consumer.start();
            }
        }
    }

    @Override
    protected void doDestroy() {
        this.shutdown();
    }

    @Override
    public void suspend() {
        if (this.consumer.isStarted()) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void shutdown() {
        if (this.consumer.isStarted()) {
            this.consumer.shutdown();
        }
    }

    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }
}

