package com.bxm.warcar.response;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <p> 接口返回结果model </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
public class ResponseModel<T> implements Serializable {
    private static final long serialVersionUID = 8107448352824904837L;

    /**
     * 返回结果对象
     */
    private T returnValue;

    /**
     * 返回结果成功标志
     */
    private boolean isSuccessed = true;

    /**
     * 结果编码
     */
    private String code;

    /**
     * 结果描述
     */
    private String codeDesc;

    private ResponseModel() {}

    public static <E extends Serializable> ResponseModel<E> newInstance() {
        return new ResponseModel<E>();
    }

    public T getReturnValue() {
        return returnValue;
    }

    public void setReturnValue(T returnValue) {
        this.returnValue = returnValue;
    }

    public boolean isSuccessed() {
        return isSuccessed;
    }

    public void setSuccessed(boolean successed) {
        this.isSuccessed = successed;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeDesc() {
        return codeDesc;
    }

    public void setCodeDesc(String codeDesc) {
        this.codeDesc = codeDesc;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

}
