package com.bxm.warcar.response;

import java.io.Serializable;

/**
 * <p> 接口返回结果model工厂类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/26
 */
public final class ResponseModelFactory {

    private ResponseModelFactory(){}

    /**
     * 创建返回结果，参数自定义设置
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> getResponseModel(){
        return ResponseModel.newInstance();
    }

    /**
     * 成功返回
     * @param returnValue 返回结果对象
     * @param <T>
     * @return
     */
    public static  <T extends Serializable> ResponseModel<T> SUCCESS(T returnValue){
        return  SUCCESS(returnValue,ResponseCode.SUCCESS.code,ResponseCode.SUCCESS.codeDesc);
    }

    /**
     * 成功返回
     * @param returnValue 返回结果对象
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> SUCCESS(T returnValue,String code,String codeDesc) {
        return getResponseModel(returnValue,true,code,codeDesc);
    }

    /**
     * 请求失败
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> FAILED400() {
        return FAILED(ResponseCode.REQUEST_ERROR.code,ResponseCode.REQUEST_ERROR.codeDesc);
    }

    /**
     * 登录失败
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> FAILED401(){
        return FAILED(ResponseCode.LOGIN_ERROR.code,ResponseCode.LOGIN_ERROR.codeDesc);
    }

    /**
     * 请求超时
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> FAILED408(){
        return FAILED(ResponseCode.TIMEOUT_ERROR.code,ResponseCode.TIMEOUT_ERROR.codeDesc);
    }

    /**
     * 系统出错
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> FAILED500() {
        return FAILED(ResponseCode.SYSTEM_ERROR.code,ResponseCode.SYSTEM_ERROR.codeDesc);
    }

    /**
     * 返回失败，失败编码自定义
     * @param code 失败编码
     * @param codeDesc 失败描述
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> FAILED(String code, String codeDesc) {
        return getResponseModel(null,false,code,codeDesc);
    }

    /**
     * 创建返回结果
     * @param returnValue
     * @param isSuccessed
     * @param code
     * @param codeDesc
     * @param <T>
     * @return
     */
    public static <T extends Serializable> ResponseModel<T> getResponseModel(T returnValue,boolean isSuccessed,String code,String codeDesc){
        ResponseModel response = getResponseModel();
        response.setSuccessed(isSuccessed);
        response.setCode(code);
        response.setCodeDesc(codeDesc);
        if(null != returnValue){
            response.setReturnValue(response);
        }
        return response;
    }


    public static enum ResponseCode {

        SUCCESS("200","OK"),//成功
        REQUEST_ERROR("400","the parameters error"),//请求出错
        LOGIN_ERROR("401","login error"),//登录出错
        TIMEOUT_ERROR("408","login error"),//超时
        SYSTEM_ERROR("500","system error");//系统错误

        String code;
        String codeDesc;

        ResponseCode(String code,String codeDesc){
            this.code = code;
            this.codeDesc = codeDesc;
        }
    }
}
