/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.CompareValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import org.apache.commons.beanutils.PropertyUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;


public class NotGreatThanValidator extends CompareValidator {

	public NotGreatThanValidator(Field field, Field compareField) {
		super(field, compareField);
	}

	@Override
	protected void doValidate(Object input) throws Exception {

		long v0 = getValueL(input);
		long v1 = getCompareValueL(input);
		if (v0 > v1) {
			throw new ConstraintViolationException(this, v0 + "," + v1);
		}
	}

	private long getCompareValueL(Object input) {
		try {
			Number v = (Number) PropertyUtils.getProperty(input, getCompareFieldName());
			return v.longValue();
		} catch (IllegalAccessException e) {
			throw new ValidateException("getCompareValueL:", e);
		} catch (InvocationTargetException e) {
			throw new ValidateException("getCompareValueL:", e);
		} catch (NoSuchMethodException e) {
			throw new ValidateException("getCompareValueL:", e);
		}
	}

	private long getValueL(Object input) {
		try {
			Number v = (Number) PropertyUtils.getProperty(input, getFieldName());
			return v.longValue();
		} catch (IllegalAccessException e) {
			throw new ValidateException("getValueL:", e);
		} catch (InvocationTargetException e) {
			throw new ValidateException("getValueL:", e);
		} catch (NoSuchMethodException e) {
			throw new ValidateException("getValueL:", e);
		}
	}

	private String getCompareFieldDesc() {
		return getFieldDesc(getCompareField());
	}

	@Override
	public String getConstraintDesc() {
		return new StringBuilder(64).append(getFieldDesc()).append(" must not be great than ")
				.append(getCompareFieldDesc()).toString();
	}
}
