/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.configure.reader;

import com.bxm.warcar.configure.PropertiesReader;
import com.bxm.warcar.configure.reader.properties.PropertiesPropertiesReader;
import com.bxm.warcar.configure.reader.yaml.YamlPropertiesReader;
import org.apache.commons.lang.StringUtils;

/**
 * <h3>Properties reader factory.</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/21
 */
public final class PropertiesReaderFactory {

    private PropertiesReaderFactory() {}

    public static PropertiesReader create(String key) {
        if (StringUtils.endsWithIgnoreCase(key, ".yml")) {
            return new YamlPropertiesReader();
        }
        // append more reader implementation in future.
        // default is properties reader.

        return new PropertiesPropertiesReader();
    }
}
