package com.bxm.warcar.integration.interceptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 拦截器
 *
 * @author allen
 * @date 2017-11-28
 */
public interface Interceptor {

    /**
     * 业务处理
     * @param invocation
     */
    void intercept(Invocation invocation);

    public static final Interceptor END = new Interceptor() {

        private final Logger LOGGER = LoggerFactory.getLogger(Interceptor.class);

        @Override
        public void intercept(Invocation invocation) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Interceptor execution chain is ended.");
            }
        }
    };
}
