package com.bxm.foundation.base.facade.service;

/**
 * 域名服务
 *
 * @author liujia
 * @date 6/15/21 6:19 PM
 **/
public interface DomainFacadeService {

    /**
     * 获取业务的服务端的API域名（面向用户的API的网关对应的域名）
     *
     * @return 业务服务端API域名, 不包含最后一个/
     */
    String getServerApiUrl();

    /**
     * 获取业务的服务端的API域名（面向用户的API的网关对应的域名）
     * 如果对应的app有配置特殊的域名，则优先采用
     *
     * @param srcApp 应用名称编码，基础请求参数中存在
     * @return 业务服务端API域名, 不包含最后一个/
     */
    String getServerApiUrl(String srcApp);

    /**
     * 获取第三方服务的API域名（第三方服务的网关对应的域名）
     *
     * @return 第三方服务端API域名, 不包含最后一个/
     */
    String getThirdPartyApiUrl();

    /**
     * 获取运营管理后台的服务端的API域名（运营管理后台网关对应的域名）
     *
     * @return 运营后台服务端API域名, 不包含最后一个/
     */
    String getManageApiUrl();

    /**
     * 获取业务域名
     *
     * @param srcApp 应用名称编码，基础请求参数中存在
     * @param scene  业务域名的应用场景
     * @return 当前应用对应的场景下的可用域名, 不包含最后一个/
     */
    String getBizDomain(String srcApp, String scene);
}
