package com.bxm.foundation.base.facade.service;

import java.util.concurrent.TimeUnit;

/**
 * 构建短链接服务
 *
 * @author liujia
 * @date 6/15/21 6:28 PM
 **/
public interface ShortUrlFacadeService {

    /**
     * 创建生成一个短链接
     * 默认30天后过期
     *
     * @param sourceUrl 原始链接
     * @return 生成后的短链接
     */
    String generator(String sourceUrl);

    /**
     * 生成短链，并在指定的时间后过期
     *
     * @param sourceUrl 原始链接
     * @param time      过期时间
     * @param timeUnit  过期时间对应的时间单位
     * @return 生成后的短链接
     */
    String generator(String sourceUrl, long time, TimeUnit timeUnit);

    /**
     * 短链接编码
     *
     * @param code 短链接的唯一编码
     * @return 短链接对应的原始链接
     */
    String get(String code);

    /**
     * 获取短链接并重新设置过期时间，
     *
     * @param code     短链接的唯一编码
     * @param time     更新过期时间
     * @param timeUnit 更新过期时间的时间单位
     * @return 原始链接
     */
    String touch(String code, long time, TimeUnit timeUnit);
}
