/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.SchedulerInvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMCriticalThreadUncaughtExceptionHandler;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ReleaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSOpDurations;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSPreemptionThread;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.InvalidQueueNameException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
extends AbstractYarnScheduler<FSAppAttempt, FSSchedulerNode> {
    private FairSchedulerConfiguration conf;
    private FSContext context;
    private YarnAuthorizationProvider authorizer;
    private Resource incrAllocation;
    private QueueManager queueMgr;
    private boolean usePortForNodeName;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private static final Log STATE_DUMP_LOG = LogFactory.getLog((String)(FairScheduler.class.getName() + ".statedump"));
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private static final ResourceCalculator DOMINANT_RESOURCE_CALCULATOR = new DominantResourceCalculator();
    public static final Resource CONTAINER_RESERVED = Resources.createResource((int)-1);
    private final int UPDATE_DEBUG_FREQUENCY = 25;
    private int updatesToSkipForDebug = 25;
    @VisibleForTesting
    Thread schedulingThread;
    Thread preemptionThread;
    FSQueueMetrics rootMetrics;
    FSOpDurations fsOpDurations;
    private float reservableNodesRatio;
    protected boolean sizeBasedWeight;
    protected boolean continuousSchedulingEnabled;
    protected volatile int continuousSchedulingSleepMs;
    private Comparator<FSSchedulerNode> nodeAvailableResourceComparator = new NodeAvailableResourceComparator();
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    protected long nodeLocalityDelayMs;
    protected long rackLocalityDelayMs;
    protected boolean assignMultiple;
    @VisibleForTesting
    boolean maxAssignDynamic;
    protected int maxAssign;
    @VisibleForTesting
    final MaxRunningAppsEnforcer maxRunningEnforcer;
    private AllocationFileLoaderService allocsLoader;
    @VisibleForTesting
    AllocationConfiguration allocConf;
    @VisibleForTesting
    Resource reservationThreshold;

    public FairScheduler() {
        super(FairScheduler.class.getName());
        this.context = new FSContext(this);
        this.allocsLoader = new AllocationFileLoaderService();
        this.queueMgr = new QueueManager(this);
        this.maxRunningEnforcer = new MaxRunningAppsEnforcer(this);
    }

    public FSContext getContext() {
        return this.context;
    }

    public boolean isAtLeastReservationThreshold(ResourceCalculator resourceCalculator, Resource resource) {
        return Resources.greaterThanOrEqual((ResourceCalculator)resourceCalculator, (Resource)this.getClusterResource(), (Resource)resource, (Resource)this.reservationThreshold);
    }

    private void validateConf(FairSchedulerConfiguration config) {
        int minMem = config.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = config.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem < 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration: yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ".  Both values must be greater than or equal to 0and the maximum allocation value must be greater than or equal tothe minimum allocation value.");
        }
        long incrementMem = config.getIncrementAllocation().getMemorySize();
        if (incrementMem <= 0L) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration: yarn.scheduler.increment-allocation-mb=" + incrementMem + ". Values must be greater than 0.");
        }
        int minVcores = config.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = config.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores < 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration: yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ".  Both values must be greater than or equal to 0and the maximum allocation value must be greater than or equal tothe minimum allocation value.");
        }
        int incrementVcore = config.getIncrementAllocation().getVirtualCores();
        if (incrementVcore <= 0) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration: yarn.scheduler.increment-allocation-vcores=" + incrementVcore + ". Values must be greater than 0.");
        }
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public int getNumNodesInRack(String rackName) {
        return this.nodeTracker.nodeCount(rackName);
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    private void dumpSchedulerState() {
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        Resource clusterResource = this.getClusterResource();
        STATE_DUMP_LOG.debug((Object)("FairScheduler state: Cluster Capacity: " + clusterResource + "  Allocations: " + this.rootMetrics.getAllocatedResources() + "  Availability: " + Resource.newInstance((long)this.rootMetrics.getAvailableMB(), (int)this.rootMetrics.getAvailableVirtualCores()) + "  Demand: " + rootQueue.getDemand()));
        STATE_DUMP_LOG.debug((Object)rootQueue.dumpState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void update() {
        long start = this.getClock().getTime();
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        this.writeLock.lock();
        try {
            rootQueue.updateDemand();
            rootQueue.update(this.getClusterResource());
            this.updateRootQueueMetrics();
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            if (this.shouldAttemptPreemption()) {
                for (FSLeafQueue queue : this.queueMgr.getLeafQueues()) {
                    queue.updateStarvedApps();
                }
            }
            if (STATE_DUMP_LOG.isDebugEnabled() && --this.updatesToSkipForDebug < 0) {
                this.updatesToSkipForDebug = 25;
                this.dumpSchedulerState();
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.fsOpDurations.addUpdateThreadRunDuration(this.getClock().getTime() - start);
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public boolean isSizeBasedWeight() {
        return this.sizeBasedWeight;
    }

    public Resource getIncrementResourceCapability() {
        return this.incrAllocation;
    }

    private FSSchedulerNode getFSSchedulerNode(NodeId nodeId) {
        return (FSSchedulerNode)this.nodeTracker.getNode(nodeId);
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public long getNodeLocalityDelayMs() {
        return this.nodeLocalityDelayMs;
    }

    public long getRackLocalityDelayMs() {
        return this.rackLocalityDelayMs;
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.continuousSchedulingEnabled;
    }

    public int getContinuousSchedulingSleepMs() {
        return this.continuousSchedulingSleepMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addApplication(ApplicationId applicationId, String queueName, String user, boolean isAppRecovering) {
        if (queueName == null || queueName.isEmpty()) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an empty queue name.";
            this.rejectApplicationWithMessage(applicationId, message);
            return;
        }
        if (queueName.startsWith(".") || queueName.endsWith(".")) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an illegal queue name " + queueName + ". The queue name cannot start/end with period.";
            this.rejectApplicationWithMessage(applicationId, message);
            return;
        }
        try {
            List<SchedulerUtils.MaxResourceValidationResult> invalidAMResourceRequests;
            this.writeLock.lock();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
            FSLeafQueue queue = this.assignToQueue(rmApp, queueName, user, applicationId);
            if (queue == null) {
                return;
            }
            if (rmApp != null && rmApp.getAMResourceRequests() != null && !(invalidAMResourceRequests = this.validateResourceRequests(rmApp.getAMResourceRequests(), queue)).isEmpty()) {
                String msg = String.format("Cannot submit application %s to queue %s because it has zero amount of resource for a requested resource! Invalid requested AM resources: %s, maximum queue resources: %s", applicationId, queue.getName(), invalidAMResourceRequests, queue.getMaxShare());
                this.rejectApplicationWithMessage(applicationId, msg);
                queue.removeAssignedApp(applicationId);
                return;
            }
            UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
            if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
                String msg = "User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName() + "(requested queuename is " + queueName + ")";
                this.rejectApplicationWithMessage(applicationId, msg);
                queue.removeAssignedApp(applicationId);
                return;
            }
            SchedulerApplication application = new SchedulerApplication(queue, user);
            this.applications.put(applicationId, application);
            queue.getMetrics().submitApp(user);
            LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queue.getName() + ", currently num of applications: " + this.applications.size()));
            if (isAppRecovering) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
                }
            } else {
                if (rmApp != null && rmApp.getApplicationSubmissionContext() != null) {
                    rmApp.getApplicationSubmissionContext().setQueue(queue.getName());
                }
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        try {
            this.writeLock.lock();
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
            String user = application.getUser();
            FSLeafQueue queue = (FSLeafQueue)application.getQueue();
            FSAppAttempt attempt = new FSAppAttempt(this, applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
            if (transferStateFromPreviousAttempt) {
                attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
            }
            application.setCurrentAppAttempt(attempt);
            boolean runnable = this.maxRunningEnforcer.canAppBeRunnable(queue, attempt);
            queue.addApp(attempt, runnable);
            if (runnable) {
                this.maxRunningEnforcer.trackRunnableApp(attempt);
            } else {
                this.maxRunningEnforcer.trackNonRunnableApp(attempt);
            }
            queue.getMetrics().submitAppAttempt(user);
            LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user: " + user));
            if (isAttemptRecovering) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(applicationAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
                }
            } else {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user) {
        return this.assignToQueue(rmApp, queueName, user, null);
    }

    private FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user, ApplicationId applicationId) {
        FSQueue queue = null;
        String appRejectMsg = null;
        try {
            QueuePlacementPolicy placementPolicy = this.allocConf.getPlacementPolicy();
            queueName = placementPolicy.assignAppToQueue(queueName, user);
            if (queueName == null) {
                appRejectMsg = "Application rejected by queue placement policy";
            } else {
                queue = this.queueMgr.getLeafQueue(queueName, true, applicationId);
                if (queue == null) {
                    appRejectMsg = queueName + " is not a leaf queue";
                }
            }
        }
        catch (IllegalStateException se) {
            appRejectMsg = "Unable to match app " + rmApp.getApplicationId() + " to a queue placement policy, and no valid terminal queue  placement rule is configured. Please contact an administrator  to confirm that the fair scheduler configuration contains a  valid terminal queue placement rule.";
        }
        catch (InvalidQueueNameException qne) {
            appRejectMsg = qne.getMessage();
        }
        catch (IOException ioe) {
            appRejectMsg = "Error assigning app to a queue: " + ioe.getMessage();
        }
        if (appRejectMsg != null && rmApp != null) {
            this.rejectApplicationWithMessage(rmApp.getApplicationId(), appRejectMsg);
            return null;
        }
        if (rmApp != null) {
            rmApp.setQueue(queue.getName());
        } else {
            LOG.error((Object)"Couldn't find RM app to set queue name on");
        }
        return queue;
    }

    private void removeApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.remove(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
        } else {
            application.stop(finalState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        try {
            this.writeLock.lock();
            LOG.info((Object)("Application " + applicationAttemptId + " is done. finalState=" + (Object)((Object)rmAppAttemptFinalState)));
            FSAppAttempt attempt = (FSAppAttempt)this.getApplicationAttempt(applicationAttemptId);
            if (attempt == null) {
                LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
                return;
            }
            if (attempt.isStopped()) {
                LOG.info((Object)("Application " + applicationAttemptId + " has already been stopped!"));
                return;
            }
            for (RMContainer rmContainer : attempt.getLiveContainers()) {
                if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                    LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                    continue;
                }
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
            }
            for (RMContainer rmContainer : attempt.getReservedContainers()) {
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
            }
            attempt.stop(rmAppAttemptFinalState);
            FSLeafQueue queue = this.queueMgr.getLeafQueue(attempt.getQueue().getQueueName(), false);
            boolean wasRunnable = queue.removeApp(attempt);
            if (wasRunnable) {
                this.maxRunningEnforcer.untrackRunnableApp(attempt);
                this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, attempt.getQueue());
            } else {
                this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completedContainerInternal(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        try {
            this.writeLock.lock();
            Container container = rmContainer.getContainer();
            FSAppAttempt application = (FSAppAttempt)this.getCurrentAttemptForContainer(container.getId());
            ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
            if (application == null) {
                LOG.info((Object)("Container " + container + " of finished application " + appId + " completed with event " + (Object)((Object)event)));
                return;
            }
            NodeId nodeID = container.getNodeId();
            FSSchedulerNode node = this.getFSSchedulerNode(nodeID);
            if (rmContainer.getState() == RMContainerState.RESERVED) {
                if (node != null) {
                    application.unreserve(rmContainer.getReservedSchedulerKey(), node);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping unreserve on removed node: " + nodeID));
                }
            } else {
                application.containerCompleted(rmContainer, containerStatus, event);
                if (node != null) {
                    node.releaseContainer(rmContainer.getContainerId(), false);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipping container release on removed node: " + nodeID));
                }
                this.updateRootQueueMetrics();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + (node == null ? nodeID : node) + " with event: " + (Object)((Object)event)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(List<NMContainerStatus> containerReports, RMNode node) {
        try {
            this.writeLock.lock();
            FSSchedulerNode schedulerNode = new FSSchedulerNode(node, this.usePortForNodeName);
            this.nodeTracker.addNode(schedulerNode);
            this.triggerUpdate();
            Resource clusterResource = this.getClusterResource();
            this.queueMgr.getRootQueue().setSteadyFairShare(clusterResource);
            this.queueMgr.getRootQueue().recomputeSteadyShares();
            LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + clusterResource));
            this.recoverContainersOnNode(containerReports, node);
            this.updateRootQueueMetrics();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(RMNode rmNode) {
        try {
            this.writeLock.lock();
            NodeId nodeId = rmNode.getNodeID();
            FSSchedulerNode node = (FSSchedulerNode)this.nodeTracker.getNode(nodeId);
            if (node == null) {
                LOG.error((Object)("Attempting to remove non-existent node " + nodeId));
                return;
            }
            List<RMContainer> runningContainers = node.getCopiedListOfRunningContainers();
            for (RMContainer container : runningContainers) {
                super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
            }
            RMContainer reservedContainer = node.getReservedContainer();
            if (reservedContainer != null) {
                super.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
            }
            this.nodeTracker.removeNode(nodeId);
            Resource clusterResource = this.getClusterResource();
            this.queueMgr.getRootQueue().setSteadyFairShare(clusterResource);
            this.queueMgr.getRootQueue().recomputeSteadyShares();
            this.updateRootQueueMetrics();
            this.triggerUpdate();
            LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + clusterResource));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Resource getNormalizedResource(Resource requestedResource) {
        return SchedulerUtils.getNormalizedResource(requestedResource, DOMINANT_RESOURCE_CALCULATOR, this.minimumAllocation, this.getMaximumResourceCapability(), this.incrAllocation);
    }

    @Override
    @VisibleForTesting
    public void killContainer(RMContainer container) {
        ContainerStatus status = SchedulerUtils.createKilledContainerStatus(container.getContainerId(), "Killed by RM to simulate an AM container failure");
        LOG.info((Object)("Killing container " + container));
        this.completedContainer(container, status, RMContainerEventType.KILL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        FSAppAttempt application = this.getSchedulerApp(appAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existent application " + appAttemptId.getApplicationId()));
            return EMPTY_ALLOCATION;
        }
        if (!application.getApplicationAttemptId().equals((Object)appAttemptId)) {
            LOG.error((Object)("Calling allocate on previous or removed or non existent application attempt " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        ApplicationId applicationId = application.getApplicationId();
        FSLeafQueue queue = application.getQueue();
        List<SchedulerUtils.MaxResourceValidationResult> invalidAsks = this.validateResourceRequests(ask, queue);
        if (!invalidAsks.isEmpty()) {
            throw new SchedulerInvalidResourceRequestException(String.format("Resource request is invalid for application %s because queue %s has 0 amount of resource for a resource type! Validation result: %s", applicationId, queue.getName(), invalidAsks));
        }
        this.handleContainerUpdates(application, updateRequests);
        this.normalizeRequests(ask);
        application.recordContainerRequestTime(this.getClock().getTime());
        this.releaseContainers(release, application);
        ReentrantReadWriteLock.WriteLock lock = application.getWriteLock();
        lock.lock();
        try {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                application.showRequests();
            }
        }
        finally {
            lock.unlock();
        }
        Set<ContainerId> preemptionContainerIds = application.getPreemptionContainerIds();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: post-update applicationAttemptId=" + appAttemptId + " #ask=" + ask.size() + " reservation= " + application.getCurrentReservation()));
            LOG.debug((Object)("Preempting " + preemptionContainerIds.size() + " container(s)"));
        }
        application.updateBlacklist(blacklistAdditions, blacklistRemovals);
        List<Container> newlyAllocatedContainers = application.pullNewlyAllocatedContainers();
        if (!newlyAllocatedContainers.isEmpty()) {
            application.recordContainerAllocationTime(this.getClock().getTime());
        }
        Resource headroom = application.getHeadroom();
        application.setApplicationHeadroomForMetrics(headroom);
        return new Allocation(newlyAllocatedContainers, headroom, preemptionContainerIds, null, null, application.pullUpdatedNMTokens(), null, null, application.pullNewlyPromotedContainers(), application.pullNewlyDemotedContainers());
    }

    private List<SchedulerUtils.MaxResourceValidationResult> validateResourceRequests(List<ResourceRequest> requests, FSLeafQueue queue) {
        ArrayList validationResults = Lists.newArrayList();
        for (ResourceRequest resourceRequest : requests) {
            SchedulerUtils.MaxResourceValidationResult validationResult;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Validating resource request: " + resourceRequest));
            }
            if ((validationResult = SchedulerUtils.validateResourceRequestsAgainstQueueMaxResource(resourceRequest, queue.getMaxShare())).isValid()) continue;
            validationResults.add(validationResult);
            LOG.warn((Object)String.format("Queue %s cannot handle resource requestbecause it has zero available amount of resource for a requested resource type, so the resource request is ignored! Requested resources: %s, maximum queue resources: %s", queue.getName(), resourceRequest.getCapability(), queue.getMaxShare()));
        }
        return validationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeUpdate(RMNode nm) {
        try {
            this.writeLock.lock();
            long start = this.getClock().getTime();
            super.nodeUpdate(nm);
            FSSchedulerNode fsNode = this.getFSSchedulerNode(nm.getNodeID());
            this.attemptScheduling(fsNode);
            long duration = this.getClock().getTime() - start;
            this.fsOpDurations.addNodeUpdateDuration(duration);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continuousSchedulingAttempt() throws InterruptedException {
        List<FSSchedulerNode> nodeIdList;
        long start = this.getClock().getTime();
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            nodeIdList = this.nodeTracker.sortedNodeList(this.nodeAvailableResourceComparator);
        }
        for (FSSchedulerNode node : nodeIdList) {
            try {
                if (!Resources.fitsIn((Resource)this.minimumAllocation, (Resource)node.getUnallocatedResource())) continue;
                this.attemptScheduling(node);
            }
            catch (Throwable ex) {
                LOG.error((Object)("Error while attempting scheduling for node " + node + ": " + ex.toString()), ex);
                if (!(ex instanceof YarnRuntimeException) || !(ex.getCause() instanceof InterruptedException)) continue;
                throw (InterruptedException)ex.getCause();
            }
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addContinuousSchedulingRunDuration(duration);
    }

    private boolean shouldContinueAssigning(int containers, Resource maxResourcesToAssign, Resource assignedResource) {
        if (!this.assignMultiple) {
            return false;
        }
        if (this.maxAssignDynamic) {
            return Resources.fitsIn((Resource)assignedResource, (Resource)maxResourcesToAssign);
        }
        return this.maxAssign <= 0 || containers < this.maxAssign;
    }

    static void assignPreemptedContainers(FSSchedulerNode node) {
        for (Map.Entry<FSAppAttempt, Resource> entry : node.getPreemptionList().entrySet()) {
            Resource assigned;
            FSAppAttempt app = entry.getKey();
            Resource preemptionPending = Resources.clone((Resource)entry.getValue());
            while (!(app.isStopped() || Resources.isNone((Resource)preemptionPending) || Resources.isNone((Resource)(assigned = app.assignContainer(node))) || assigned.equals((Object)CONTAINER_RESERVED))) {
                Resources.subtractFromNonNegative((Resource)preemptionPending, (Resource)assigned);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void attemptScheduling(FSSchedulerNode node) {
        try {
            NodeId nodeID;
            this.writeLock.lock();
            if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
                return;
            }
            NodeId nodeId = nodeID = node != null ? node.getNodeID() : null;
            if (!this.nodeTracker.exists(nodeID)) {
                LOG.info((Object)("Skipping scheduling as the node " + nodeID + " has been removed"));
                return;
            }
            FairScheduler.assignPreemptedContainers(node);
            FSAppAttempt reservedAppSchedulable = node.getReservedAppSchedulable();
            boolean validReservation = false;
            if (reservedAppSchedulable != null) {
                validReservation = reservedAppSchedulable.assignReservedContainer(node);
            }
            if (!validReservation) {
                int assignedContainers = 0;
                Resource assignedResource = Resources.clone((Resource)Resources.none());
                Resource maxResourcesToAssign = Resources.multiply((Resource)node.getUnallocatedResource(), (double)0.5);
                while (node.getReservedContainer() == null) {
                    Resource assignment = this.queueMgr.getRootQueue().assignContainer(node);
                    if (assignment.equals((Object)Resources.none())) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug((Object)("No container is allocated on node " + node));
                        break;
                    }
                    Resources.addTo((Resource)assignedResource, (Resource)assignment);
                    if (this.shouldContinueAssigning(++assignedContainers, maxResourcesToAssign, assignedResource)) continue;
                    break;
                }
            }
            this.updateRootQueueMetrics();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public FSAppAttempt getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return (FSAppAttempt)super.getApplicationAttempt(appAttemptId);
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return RESOURCE_CALCULATOR;
    }

    private void updateRootQueueMetrics() {
        this.rootMetrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.getClusterResource(), (Resource)this.rootMetrics.getAllocatedResources()));
    }

    private boolean shouldAttemptPreemption() {
        if (this.context.isPreemptionEnabled()) {
            return this.context.getPreemptionUtilizationThreshold() < Math.max((float)this.rootMetrics.getAllocatedMB() / (float)this.getClusterResource().getMemorySize(), (float)this.rootMetrics.getAllocatedVirtualCores() / (float)this.getClusterResource().getVirtualCores());
        }
        return false;
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queueName = this.resolveReservationQueueName(appAddedEvent.getQueue(), appAddedEvent.getApplicationId(), appAddedEvent.getReservationID(), appAddedEvent.getIsAppRecovering());
                if (queueName == null) break;
                this.addApplication(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getIsAppRecovering());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                if (!(event instanceof NodeResourceUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                if (!(event instanceof AppAttemptAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                if (!(event instanceof AppAttemptRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.removeApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case RELEASE_CONTAINER: {
                if (!(event instanceof ReleaseContainerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                RMContainer container = ((ReleaseContainerEvent)event).getContainer();
                this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released by application"), RMContainerEventType.RELEASED);
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                super.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveReservationQueueName(String queueName, ApplicationId applicationId, ReservationId reservationID, boolean isRecovering) {
        try {
            this.readLock.lock();
            FSQueue queue = this.queueMgr.getQueue(queueName);
            if (queue == null || !this.allocConf.isReservable(queue.getQueueName())) {
                String string = queueName;
                return string;
            }
            queueName = queue.getQueueName();
            if (reservationID != null) {
                String resQName = queueName + "." + reservationID.toString();
                queue = this.queueMgr.getQueue(resQName);
                if (queue == null) {
                    if (isRecovering && this.allocConf.getMoveOnExpiry(queueName)) {
                        String string = this.getDefaultQueueForPlanQueue(queueName);
                        return string;
                    }
                    String message = "Application " + applicationId + " submitted to a reservation which is not yet currently active: " + resQName;
                    this.rejectApplicationWithMessage(applicationId, message);
                    String string = null;
                    return string;
                }
                if (!queue.getParent().getQueueName().equals(queueName)) {
                    String message = "Application: " + applicationId + " submitted to a reservation " + resQName + " which does not belong to the specified queue: " + queueName;
                    this.rejectApplicationWithMessage(applicationId, message);
                    String string = null;
                    return string;
                }
                queueName = resQName;
            } else {
                queueName = this.getDefaultQueueForPlanQueue(queueName);
            }
            String string = queueName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void rejectApplicationWithMessage(ApplicationId applicationId, String msg) {
        LOG.info((Object)msg);
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, msg));
    }

    private String getDefaultQueueForPlanQueue(String queueName) {
        String planName = queueName.substring(queueName.lastIndexOf(".") + 1);
        queueName = queueName + "." + planName + "-default";
        return queueName;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private void initScheduler(Configuration conf) throws IOException {
        try {
            this.writeLock.lock();
            this.conf = new FairSchedulerConfiguration(conf);
            this.validateConf(this.conf);
            this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
            this.minimumAllocation = super.getMinimumAllocation();
            this.initMaximumResourceCapability(super.getMaximumAllocation());
            this.incrAllocation = this.conf.getIncrementAllocation();
            this.updateReservationThreshold();
            this.continuousSchedulingEnabled = this.conf.isContinuousSchedulingEnabled();
            this.continuousSchedulingSleepMs = this.conf.getContinuousSchedulingSleepMs();
            this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
            this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
            this.nodeLocalityDelayMs = this.conf.getLocalityDelayNodeMs();
            this.rackLocalityDelayMs = this.conf.getLocalityDelayRackMs();
            this.assignMultiple = this.conf.getAssignMultiple();
            this.maxAssignDynamic = this.conf.isMaxAssignDynamic();
            this.maxAssign = this.conf.getMaxAssign();
            this.sizeBasedWeight = this.conf.getSizeBasedWeight();
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.reservableNodesRatio = this.conf.getReservableNodes();
            this.updateInterval = this.conf.getUpdateInterval();
            if (this.updateInterval < 0L) {
                this.updateInterval = 500L;
                LOG.warn((Object)"yarn.scheduler.fair.update-interval-ms is invalid, so using default value 500 ms instead");
            }
            this.rootMetrics = FSQueueMetrics.forQueue("root", null, true, conf);
            this.fsOpDurations = FSOpDurations.getInstance(true);
            this.applications = new ConcurrentHashMap();
            this.allocConf = new AllocationConfiguration(conf);
            try {
                this.queueMgr.initialize(conf);
            }
            catch (Exception e) {
                throw new IOException("Failed to start FairScheduler", e);
            }
            if (this.continuousSchedulingEnabled) {
                LOG.warn((Object)"Continuous scheduling is turned ON. It is deprecated because it can cause scheduler slowness due to locking issues. Schedulers should use assignmultiple as a replacement.");
                this.schedulingThread = new ContinuousSchedulingThread();
                this.schedulingThread.setName("FairSchedulerContinuousScheduling");
                this.schedulingThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
                this.schedulingThread.setDaemon(true);
            }
            if (this.conf.getPreemptionEnabled()) {
                this.createPreemptionThread();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.allocsLoader.init(conf);
        this.allocsLoader.setReloadListener(new AllocationReloadListener());
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize FairScheduler", e);
        }
    }

    @VisibleForTesting
    protected void createPreemptionThread() {
        this.preemptionThread = new FSPreemptionThread(this);
        this.preemptionThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
    }

    private void updateReservationThreshold() {
        Resource newThreshold;
        this.reservationThreshold = newThreshold = Resources.multiply((Resource)this.getIncrementResourceCapability(), (double)this.conf.getReservationThresholdIncrementMultiple());
    }

    private void startSchedulerThreads() {
        try {
            this.writeLock.lock();
            Preconditions.checkNotNull((Object)((Object)this.allocsLoader), (Object)"allocsLoader is null");
            if (this.continuousSchedulingEnabled) {
                Preconditions.checkNotNull((Object)this.schedulingThread, (Object)"schedulingThread is null");
                this.schedulingThread.start();
            }
            if (this.preemptionThread != null) {
                this.preemptionThread.start();
            }
            this.allocsLoader.start();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        this.initScheduler(conf);
        super.serviceInit(conf);
    }

    @Override
    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    @Override
    public void serviceStop() throws Exception {
        try {
            this.writeLock.lock();
            if (this.continuousSchedulingEnabled && this.schedulingThread != null) {
                this.schedulingThread.interrupt();
                this.schedulingThread.join(1000L);
            }
            if (this.preemptionThread != null) {
                this.preemptionThread.interrupt();
                this.preemptionThread.join(1000L);
            }
            if (this.allocsLoader != null) {
                this.allocsLoader.stop();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        super.serviceStop();
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to reload allocations file", (Throwable)e);
        }
        try {
            this.refreshMaximumAllocation(ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)conf));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to refresh maximum allocation", (Throwable)e);
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            throw new IOException("queue " + queueName + " does not exist");
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodeTracker.nodeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        try {
            this.readLock.lock();
            FSQueue queue = this.getQueueManager().getQueue(queueName);
            if (queue == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = queue.hasAccess(acl, callerUGI);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AllocationConfiguration getAllocationConfiguration() {
        return this.allocConf;
    }

    private void setQueueAcls(Map<String, Map<AccessType, AccessControlList>> queueAcls) throws IOException {
        this.authorizer.setPermission(this.allocsLoader.getDefaultPermissions(), UserGroupInformation.getCurrentUser());
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Map.Entry<String, Map<AccessType, AccessControlList>> queueAcl : queueAcls.entrySet()) {
            permissions.add(new Permission(new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, queueAcl.getKey()), queueAcl.getValue()));
        }
        this.authorizer.setPermission(permissions, UserGroupInformation.getCurrentUser());
    }

    private void applyChildDefaults() {
        Collection<FSQueue> queues = this.queueMgr.getQueues();
        Set<String> configuredLeafQueues = this.allocConf.getConfiguredQueues().get((Object)FSQueueType.LEAF);
        Set<String> configuredParentQueues = this.allocConf.getConfiguredQueues().get((Object)FSQueueType.PARENT);
        for (FSQueue queue : queues) {
            ConfigurableResource max;
            if (queue.getParent() == null || configuredLeafQueues.contains(queue.getName()) || configuredParentQueues.contains(queue.getName()) || (max = queue.getParent().getMaxChildQueueResource()) == null) continue;
            queue.setMaxShare(max);
        }
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        FSQueue queue = this.queueMgr.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveApplication(ApplicationId appId, String queueName) throws YarnException {
        try {
            FSLeafQueue targetQueue;
            FSLeafQueue oldQueue;
            FSAppAttempt attempt;
            SchedulerApplication app;
            block12: {
                this.writeLock.lock();
                app = (SchedulerApplication)this.applications.get(appId);
                if (app == null) {
                    throw new YarnException("App to be moved " + appId + " not found.");
                }
                attempt = (FSAppAttempt)app.getCurrentAppAttempt();
                try {
                    attempt.getWriteLock().lock();
                    oldQueue = (FSLeafQueue)app.getQueue();
                    if (attempt.isStopped()) {
                        LOG.info((Object)("Application " + appId + " is stopped and can't be moved!"));
                        throw new YarnException("Application " + appId + " is stopped and can't be moved!");
                    }
                    String destQueueName = this.handleMoveToPlanQueue(queueName);
                    targetQueue = this.queueMgr.getLeafQueue(destQueueName, false);
                    if (targetQueue == null) {
                        throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
                    }
                    if (targetQueue != oldQueue) break block12;
                    String string = oldQueue.getQueueName();
                    attempt.getWriteLock().unlock();
                    return string;
                }
                catch (Throwable throwable) {
                    attempt.getWriteLock().unlock();
                    throw throwable;
                }
            }
            if (oldQueue.isRunnableApp(attempt)) {
                this.verifyMoveDoesNotViolateConstraints(attempt, oldQueue, targetQueue);
            }
            this.executeMove(app, attempt, oldQueue, targetQueue);
            String string = targetQueue.getQueueName();
            attempt.getWriteLock().unlock();
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preValidateMoveApplication(ApplicationId appId, String newQueue) throws YarnException {
        try {
            this.writeLock.lock();
            SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
            if (app == null) {
                throw new YarnException("App to be moved " + appId + " not found.");
            }
            FSAppAttempt attempt = (FSAppAttempt)app.getCurrentAppAttempt();
            try {
                attempt.getWriteLock().lock();
                FSLeafQueue oldQueue = (FSLeafQueue)app.getQueue();
                String destQueueName = this.handleMoveToPlanQueue(newQueue);
                FSLeafQueue targetQueue = this.queueMgr.getLeafQueue(destQueueName, false);
                if (targetQueue == null) {
                    throw new YarnException("Target queue " + newQueue + " not found or is not a leaf queue.");
                }
                if (oldQueue.isRunnableApp(attempt)) {
                    this.verifyMoveDoesNotViolateConstraints(attempt, oldQueue, targetQueue);
                }
            }
            finally {
                attempt.getWriteLock().unlock();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void verifyMoveDoesNotViolateConstraints(FSAppAttempt app, FSLeafQueue oldQueue, FSLeafQueue targetQueue) throws YarnException {
        String queueName = targetQueue.getQueueName();
        ApplicationAttemptId appAttId = app.getApplicationAttemptId();
        FSQueue lowestCommonAncestor = this.findLowestCommonAncestorQueue(oldQueue, targetQueue);
        Resource consumption = app.getCurrentConsumption();
        for (FSQueue cur = targetQueue; cur != lowestCommonAncestor; cur = cur.getParent()) {
            if (cur.getNumRunnableApps() == cur.getMaxRunningApps()) {
                throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxRunningApps constraints on queue " + cur.getQueueName());
            }
            if (Resources.fitsIn((Resource)Resources.add((Resource)cur.getResourceUsage(), (Resource)consumption), (Resource)cur.getMaxShare())) continue;
            throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxShare constraints on queue " + cur.getQueueName());
        }
    }

    private void executeMove(SchedulerApplication<FSAppAttempt> app, FSAppAttempt attempt, FSLeafQueue oldQueue, FSLeafQueue newQueue) throws YarnException {
        boolean wasRunnable = oldQueue.isRunnableApp(attempt);
        boolean nowRunnable = this.maxRunningEnforcer.canAppBeRunnable(newQueue, attempt);
        if (wasRunnable && !nowRunnable) {
            throw new YarnException("Should have already verified that app " + attempt.getApplicationId() + " would be runnable in new queue");
        }
        oldQueue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
        } else if (nowRunnable) {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
        attempt.move(newQueue);
        app.setQueue(newQueue);
        newQueue.addApp(attempt, nowRunnable);
        if (nowRunnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        }
        if (wasRunnable) {
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, oldQueue);
        }
    }

    @VisibleForTesting
    FSQueue findLowestCommonAncestorQueue(FSQueue queue1, FSQueue queue2) {
        String name1 = queue1.getName();
        String name2 = queue2.getName();
        int lastPeriodIndex = -1;
        for (int i = 0; i < Math.max(name1.length(), name2.length()); ++i) {
            if (name1.length() <= i || name2.length() <= i || name1.charAt(i) != name2.charAt(i)) {
                return this.queueMgr.getQueue(name1.substring(0, lastPeriodIndex));
            }
            if (name1.charAt(i) != '.') continue;
            lastPeriodIndex = i;
        }
        return queue1;
    }

    @Override
    public void updateNodeResource(RMNode nm, ResourceOption resourceOption) {
        try {
            this.writeLock.lock();
            super.updateNodeResource(nm, resourceOption);
            this.updateRootQueueMetrics();
            this.queueMgr.getRootQueue().setSteadyFairShare(this.getClusterResource());
            this.queueMgr.getRootQueue().recomputeSteadyShares();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU);
    }

    @Override
    public Set<String> getPlanQueues() throws YarnException {
        HashSet<String> planQueues = new HashSet<String>();
        for (FSQueue fsQueue : this.queueMgr.getQueues()) {
            String queueName = fsQueue.getName();
            if (!this.allocConf.isReservable(queueName)) continue;
            planQueues.add(queueName);
        }
        return planQueues;
    }

    @Override
    public void setEntitlement(String queueName, QueueEntitlement entitlement) throws YarnException {
        FSLeafQueue reservationQueue = this.queueMgr.getLeafQueue(queueName, false);
        if (reservationQueue == null) {
            throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
        }
        reservationQueue.setWeights(entitlement.getCapacity());
    }

    @Override
    public void removeQueue(String queueName) throws YarnException {
        FSLeafQueue reservationQueue = this.queueMgr.getLeafQueue(queueName, false);
        if (reservationQueue != null && !this.queueMgr.removeLeafQueue(queueName)) {
            throw new YarnException("Could not remove queue " + queueName + " as its either not a leaf queue or its not empty");
        }
    }

    private String handleMoveToPlanQueue(String targetQueueName) {
        FSQueue dest = this.queueMgr.getQueue(targetQueueName);
        if (dest != null && this.allocConf.isReservable(dest.getQueueName())) {
            targetQueueName = this.getDefaultQueueForPlanQueue(targetQueueName);
        }
        return targetQueueName;
    }

    public float getReservableNodesRatio() {
        return this.reservableNodesRatio;
    }

    long getNMHeartbeatInterval() {
        return this.nmHeartbeatInterval;
    }

    ReentrantReadWriteLock.ReadLock getSchedulerReadLock() {
        return this.readLock;
    }

    @Override
    public long checkAndGetApplicationLifetime(String queueName, long lifetime) {
        return lifetime;
    }

    private class AllocationReloadListener
    implements AllocationFileLoaderService.Listener {
        private AllocationReloadListener() {
        }

        @Override
        public void onReload(AllocationConfiguration queueInfo) throws IOException {
            Set<String> removedStaticQueues = this.getRemovedStaticQueues(queueInfo);
            FairScheduler.this.writeLock.lock();
            try {
                if (queueInfo == null) {
                    FairScheduler.this.authorizer.setPermission(FairScheduler.this.allocsLoader.getDefaultPermissions(), UserGroupInformation.getCurrentUser());
                } else {
                    FairScheduler.this.allocConf = queueInfo;
                    FairScheduler.this.setQueueAcls(FairScheduler.this.allocConf.getQueueAcls());
                    FairScheduler.this.allocConf.getDefaultSchedulingPolicy().initialize(FairScheduler.this.getContext());
                    FairScheduler.this.queueMgr.updateAllocationConfiguration(FairScheduler.this.allocConf);
                    FairScheduler.this.queueMgr.setQueuesToDynamic(removedStaticQueues);
                    FairScheduler.this.applyChildDefaults();
                    FairScheduler.this.maxRunningEnforcer.updateRunnabilityOnReload();
                }
            }
            finally {
                FairScheduler.this.writeLock.unlock();
            }
        }

        private Set<String> getRemovedStaticQueues(AllocationConfiguration queueInfo) {
            if (queueInfo == null || FairScheduler.this.allocConf == null) {
                return Collections.emptySet();
            }
            HashSet<String> removedStaticQueues = new HashSet<String>();
            for (Set<String> queues : FairScheduler.this.allocConf.getConfiguredQueues().values()) {
                removedStaticQueues.addAll(queues);
            }
            for (Set<String> queues : queueInfo.getConfiguredQueues().values()) {
                removedStaticQueues.removeAll(queues);
            }
            return removedStaticQueues;
        }

        @Override
        public void onCheck() {
            FairScheduler.this.queueMgr.removeEmptyDynamicQueues();
            FairScheduler.this.queueMgr.removePendingIncompatibleQueues();
        }
    }

    private class NodeAvailableResourceComparator
    implements Comparator<FSSchedulerNode> {
        private NodeAvailableResourceComparator() {
        }

        @Override
        public int compare(FSSchedulerNode n1, FSSchedulerNode n2) {
            return RESOURCE_CALCULATOR.compare(FairScheduler.this.getClusterResource(), n2.getUnallocatedResource(), n1.getUnallocatedResource());
        }
    }

    private class ContinuousSchedulingThread
    extends Thread {
        private ContinuousSchedulingThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    FairScheduler.this.continuousSchedulingAttempt();
                    Thread.sleep(FairScheduler.this.getContinuousSchedulingSleepMs());
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Continuous scheduling thread interrupted. Exiting.", (Throwable)e);
                    return;
                }
            }
        }
    }
}

